part of 'brand_list_view.dart';

class ListMainItem extends StatelessWidget {
  final bool hasMore;
  final bool isLoading;
  final VoidCallback onViewMore;
  final BrandNotifier notifier;
  final BrandState state;
  final ProductNotifier productNotifier;
  final AddBrandNotifier addBrandNotifier;

  const ListMainItem({
    super.key,
    required this.hasMore,
    required this.onViewMore,
    required this.isLoading,
    required this.notifier,
    required this.state,
    required this.productNotifier,
    required this.addBrandNotifier,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        return Column(
          children: [
            Row(
              children: [
                Text(
                  AppHelpers.getTranslation(TrKeys.brands),
                  style: Style.interMedium(size: 20),
                ),
                Spacer(),
                CustomRefresher(
                  onTap: () {
                    notifier.fetchAllBrands(isRefresh: true, context: context);
                  },
                  isLoading: state.isLoading,
                ),
                10.horizontalSpace,
                LoginButton(
                  bgColor: Style.black,
                  icon: Icon(
                    Remix.add_circle_line,
                    color: Style.white,
                    size: 24.r,
                  ),
                  onPressed: () {
                    addBrandNotifier.clear();
                    productNotifier.changeState(5);
                  },
                  title: AppHelpers.getTranslation(TrKeys.addBrand),
                ),
              ],
            ),
            8.verticalSpace,
            Container(
              decoration: const BoxDecoration(
                color: Style.white,
                borderRadius: BorderRadius.vertical(top: Radius.circular(6)),
              ),
              padding: const EdgeInsets.symmetric(vertical: 18, horizontal: 18),
              child: Row(
                children: [
                  CustomCheckbox(
                    isActive: state.isAllSelect,
                    onTap: () => notifier.allSelectOrder(state.allBrands),
                  ),
                  8.horizontalSpace,
                  SizedBox(
                    width: constraints.maxWidth / 19,
                    child: Text(
                      AppHelpers.getTranslation(TrKeys.id),
                      style: Style.interNormal(size: 16),
                    ),
                  ),
                  8.horizontalSpace,
                  SizedBox(
                    width: 56,
                    child: Text(
                      AppHelpers.getTranslation(TrKeys.image),
                      style: Style.interNormal(size: 16),
                    ),
                  ),
                  8.horizontalSpace,
                  SizedBox(
                    width: constraints.maxWidth / 4,
                    child: Text(
                      AppHelpers.getTranslation(TrKeys.title),
                      style: Style.interNormal(size: 16),
                    ),
                  ),
                  8.horizontalSpace,
                  SizedBox(
                    width: constraints.maxWidth / 4,
                    child: Text(
                      AppHelpers.getTranslation(TrKeys.createdDate),
                      style: Style.interNormal(size: 16),
                    ),
                  ),
                  8.horizontalSpace,
                  if (constraints.maxWidth > 880)
                    SizedBox(
                      width: constraints.maxWidth / 9,
                      child: Text(
                        AppHelpers.getTranslation(TrKeys.active),
                        style: Style.interNormal(size: 16),
                      ),
                    ),
                ],
              ),
            ),
            const Divider(height: 2),
            Expanded(
              child: !isLoading
                  ? ListView(
                      children: [
                        ListView.builder(
                          shrinkWrap: true,
                          physics: const NeverScrollableScrollPhysics(),
                          itemCount: state.allBrands.length,
                          itemBuilder: (context, index) {
                            return BrandListItem(
                              brandData: state.allBrands[index],
                              onSelect: () => notifier.addSelectOrder(
                                id: state.allBrands[index].id,
                                orderLength: state.allBrands.length,
                              ),
                              isSelect: state.selectBrands.contains(
                                state.allBrands[index].id,
                              ),
                              isLoading: state.isLoading,
                              onEdit: () {
                                addBrandNotifier.setBrand(state.brands[index]);
                                productNotifier.changeState(5);
                              },
                              constraints: constraints,
                            );
                          },
                        ),
                        24.verticalSpace,
                        (hasMore
                            ? InkWell(
                                borderRadius: BorderRadius.circular(10.r),
                                onTap: () => onViewMore(),
                                child: Container(
                                  height: 50,
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(10.r),
                                    border: Border.all(
                                      color: Style.black.withOpacity(0.17),
                                      width: 1,
                                    ),
                                  ),
                                  alignment: Alignment.center,
                                  child: Text(
                                    AppHelpers.getTranslation(TrKeys.viewMore),
                                    style: Style.interNormal(size: 16),
                                  ),
                                ),
                              )
                            : const SizedBox()),
                        24.verticalSpace,
                      ],
                    )
                  : state.allBrands.isEmpty && !state.isLoading
                  ? Center(
                      child: Text(
                        AppHelpers.getTranslation(TrKeys.emptyBrands),
                        style: Style.interMedium(),
                      ),
                    )
                  : ListView.builder(
                      physics: const NeverScrollableScrollPhysics(),
                      shrinkWrap: true,
                      itemCount: 10,
                      itemBuilder: (context, index) {
                        return Column(
                          children: [
                            Container(
                              width: double.infinity,
                              height: 72,
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(1),
                                color: Style.shimmerBase,
                              ),
                            ),
                            const Divider(height: 2, color: Style.white),
                          ],
                        );
                      },
                    ),
            ),
          ],
        );
      },
    );
  }
}
